
var x;
var y;

var image;
var ball_image;
var damage_count;
var hitpoints;
var smokes;

var rotate_angle;

var unloaded;
var xv;
var scale_angle;

var objects;
var particles;

var shot_time;

var dead;
var size;

Init(p_x,p_y,ships,p_hitpoints,p_objects,p_particles,p_size)
{
  size = p_size;
  x = p_x;
  y = p_y;
  image = ships[0];
  ball_image = ships[1];
  hitpoints = p_hitpoints;
  objects = p_objects;
  particles = p_particles;
  
  unloaded = false;
  xv = 0.5;
  
  ShipCreated();

  smokes = new Vector();
  fire = new ParticleSource(
    -1,		// expire_time
    false,	// active
    x-2-Rand(image.GetLeft()-2),	// x
    y-2-Rand(image.GetTop()/2),		// y
    0,0,	// xv, yv
    0,0,	// xa, ya
    1.0,	// p_prob
    40,40,	// p_life_min,max
    6,10,	// p_size_min,max
    -.2,.2,	// p_xv_min/max
    0,-2,	// p_yv_min/max
    0,-.025,	// p_xa, p_ya
    new Vector(new Vector(Color(255,255,0  ,128),10),
               new Vector(Color(255,64 ,0  ,128),10),
               new Vector(Color(128,0  ,0  ,64 ),10),
               new Vector(Color(64 ,64 ,64 ,64 ),10),
               new Vector(Color(64 ,64 ,64 ,0  ),0))
    );
  particles.AddSource(fire);
  smokes.Add(fire);

  fire = new ParticleSource(
    -1,		// expire_time
    false,	// active
    x+2+Rand(image.GetRight()-2),	// x
    y-2-Rand(image.GetTop()/2),		// y
    0,0,	// xv, yv
    0,0,	// xa, ya
    1.0,	// p_prob
    40,40,	// p_life_min,max
    6,10,	// p_size_min,max
    -.2,.2,	// p_xv_min/max
    0,-2,	// p_yv_min/max
    0,-.025,	// p_xa, p_ya
    new Vector(new Vector(Color(255,255,0  ,128),10),
               new Vector(Color(255,64 ,0  ,128),10),
               new Vector(Color(128,0  ,0  ,64 ),10),
               new Vector(Color(64 ,64 ,64 ,64 ),10),
               new Vector(Color(64 ,64 ,64 ,0  ),0))
    );
  particles.AddSource(fire);
  smokes.Add(fire);
  
  shot_time = 100;
}

Update()
{
  if (damage_count > 0)
    damage_count--;
    
  if (hitpoints <= 100)
    smokes[0].SetActive(true);
  if (hitpoints <= 50)
    smokes[1].SetActive(true);

  if (hitpoints <= 0)
  {
    for (i = 0; i < smokes.Size(); i++)
    {
      smokes[i].SetActive(false);
      smokes[i].Destroy();
    }
  }
  
  rotate_angle += 0.03;
  
  if (scale_angle == 0 || scale_angle == 180)
  {
    x += xv;
    
    for (i = 0; i < smokes.Size(); i++)
    {
      smoke = smokes[i];
      smoke.SetX(smoke.GetX() + xv);
    }
  }
  
  if (x > 610 && !unloaded)
  {
    xv = -xv;
    unloaded = true;
    
    objects.Add(new Raiders(x,y,particles,objects,GetRaidersImages(),this));
  }

  if (xv < 0 && scale_angle < 180)
    scale_angle += 10;
    
  if (shot_time > 0)
    shot_time--;
  else
  {
    xtarget = 845+Rand(-110,110);
    xdiff = Float(xtarget-x);
    bxv_max = (xdiff/850.0)*(7.0-3.0)+3.0;
    bxv_min = (xdiff/850.0)*(3.0-1.0)+1.0;
    bxv = Float(Rand(100))/100.0*(bxv_max-bxv_min)+bxv_min;
    t = xdiff/bxv;
    byv = 0.07*t/2.0;
    objects.Add(new Cannonball(x,y-30,bxv,-byv,particles,objects,ball_image,this));
    shot_time = Rand(100,200);
  }
}

DrawBackground()
{
}

Draw()
{
  xscale = Float(size)/100.0;
  yscale = xscale;

  if (hitpoints > 0 && damage_count > 0)
  {
    scale = 1.0;
    if (damage_count > 15)
      scale -= (5-(damage_count-15.0))*0.05;
    else if (damage_count > 10)
      scale -= (5-(15.0-damage_count))*0.05;
    else if (damage_count > 5)
      scale += (5-(damage_count-5.0))*0.05;
    else if (damage_count > 0)
      scale += (5-(5.0-damage_count))*0.05;

    xscale *= scale;
    yscale /= scale;
  }
  else if (hitpoints == 0)
  {
    yscale *= Float(damage_count)/20.0;
  }

  xscale *= 1.0 - sin(scale_angle*3.141592/180.0);

  if (scale_angle >= 90)
  {
    xscale = -xscale;
    CullFront();
  }

  if (xscale != 0 && yscale != 0)
    image.Draw(x,y,0,7*cos(rotate_angle),xscale,yscale);

  if (scale_angle >= 90)
    CullBack();
}

DrawForeground()
{
}

IsDead()
{
  if (dead)
    return dead;

  if ((xv < 0 && x < -20 - image.GetRight()) ||
      (hitpoints == 0 && damage_count == 0))
  {
    dead = true;
    
    ShipDestroyed();
    
    if (hitpoints == 0)
      ShipKilled();
    
    for (i = 0; i < smokes.Size(); i++)
    {
      smokes[i].SetActive(false);
      smokes[i].Destroy();
    }

    return true;
  }

  return dead;
}

IsDestroyable()
{
  if (hitpoints > 0)
    return true;
  else
    return false;
}

GetBounds()
{
  return image;
}

GetX()
{
  return x;
}

GetY()
{
  return y;
}

Damage(amount)
{
  if (hitpoints <= 0)
    return;

  if (damage_count == 0)
    damage_count = 20;
    
  hitpoints -= amount;

  if (hitpoints <= 0)
  {
    hitpoints = 0;
    damage_count = 20;
  }
}