
var objects;
var particles;

var houses;

var ships_alive;
var ships_dead;
var ships_killed;
var ship_create_time;

var ship_images;

var raiders_images;

Init(p_objects,p_particles)
{
  objects = p_objects;
  particles = p_particles;

  houses = new Vector();

  ship_images = LoadVGZ("art/ships.vgz");
  raiders_images = LoadVGZ("art/raiders.vgz");

  ship_create_time = Rand(160,320);
}

GetRaidersImages()
{
  return raiders_images.raiders;
}

AddHouse(house)
{
  houses.Add(house);
}

RemoveHouse(house)
{
  houses.DelValue(house);
}

ShipCreated()
{
  ships_alive++;
  ship_create_time = Rand(400,600);
}

ShipDestroyed()
{
  ships_alive--;
  ships_dead++;
  ship_create_time = Rand(200,300);
}

ShipKilled()
{
  ships_killed++;
}

FindHouse()
{
  if (houses.Size() > 0)
    return houses[0];
  else
    return null;
}

NumHouses()
{
  return houses.Size();
}

NumDeadShips()
{
  return ships_dead;
}

Update()
{
  if (ship_create_time > 0)
    ship_create_time--;

  create_ship = false;
  total_ships = ships_alive + ships_dead;

  if (ships_alive == 0)
    create_ship = true;
  else if (ships_alive == 1 && ship_create_time == 0)
    create_ship = true;
  else if (ships_alive < 3 && ship_create_time == 0 &&
           total_ships >= 10)
    create_ship = true;
  else if (ships_alive < 5 && ship_create_time == 0 &&
           total_ships >= 15)
    create_ship = true;
    
  if (total_ships >= 20)
    create_ship = false;

  if (create_ship)
    objects.Add(new Ship(-30-ship_images.ship1[0].GetRight(),715,ship_images.ship1,150,objects,particles,Rand(80,110)));
}

DrawBackground()
{
}

Draw()
{
}

DrawForeground()
{
  image = ship_images.ship2[0];
  for (i = 0; i < ships_killed && i < 10; i++)
    image.Draw(315+i*75,35);
  for (i = 10; i < ships_killed; i++)
    image.Draw(315+(i-10)*75,110);
}

IsDead()
{
  return false;
}

IsDestroyable()
{
  return false;
}
