var particles;
var dragon;

var objects;
var misc;

Main()
{
  (new GameApp(1024,768,1,"The Adventures of Bruto")).RunScript(this);
}

GameInit()
{
  particles = new ParticleManager();

  SetOrtho(true);
  
  objects = new Vector();
  objects.Add(new Background());
  
  targetgen = new TargetGenerator(objects,particles);
  objects.Add(targetgen);
  RegisterHAPIProvider(targetgen);

  houses = LoadVGZ("art/houses.vgz");
  objects.Add(new House(745,668,houses.houses[0],100,particles));
  objects.Add(new House(798,668,houses.houses[1],100,particles));
  objects.Add(new House(847,668,houses.houses[2],100,particles));
  objects.Add(new House(907,668,houses.houses[3],100,particles));
  objects.Add(new House(981,668,houses.houses[4],100,particles));

  objects.Add(new House(942,599,houses.palace[0],500,particles));
  
  dragon = new Dragon(particles,objects);
  objects.Add(dragon);

  misc = LoadVGZ("art/misc.vgz");
}

GameMain()
{
  dead = new Vector();

  gameover = (NumHouses() == 0 || NumDeadShips() == 20);
  
  if (!gameover)
  {
    for (i = 0; i < objects.Size(); i++)
    {
      objects[i].Update();
    
      if (objects[i].IsDead())
        dead.Add(objects[i]);
    }

    particles.Update();
  }

  for (i = 0; i < objects.Size(); i++)
    objects[i].DrawBackground();

  for (i = 0; i < objects.Size(); i++)
    objects[i].Draw();

  particles.Draw(GetGraphicsEngine());

  for (i = 0; i < objects.Size(); i++)
    objects[i].DrawForeground();
    
  if (gameover)
  {
    if (NumHouses() == 0)
      misc.suck[0].Draw(512,384);
    else
      misc.win[0].Draw(512,384);
  }

  for (i = 0; i < dead.Size(); i++)
    objects.DelValue(dead[i]);
}

GameShutdown()
{
  objects.Clear();
}

KeyPressed(s,m)
{
  dragon.Key(s,m,true);
}

KeyReleased(s,m)
{
  dragon.Key(s,m,false);
}