
var anims;

var water_left;
var water_pos;

var clouds;

Init()
{
  anims = LoadVGZ("art/background.vgz");
  
  clouds = new Vector();
  for (i = 0; i < 5; i++)
    clouds.Add(new DataSet());
    
  clouds[0].x = 800;
  clouds[0].y = 70;
  clouds[0].xv = 0.15;

  clouds[1].x = 100;
  clouds[1].y = 110;
  clouds[1].xv = 0.15;

  clouds[2].x = 512;
  clouds[2].y = 270;
  clouds[2].xv = 0.225;

  clouds[3].x = 150;
  clouds[3].y = 470;
  clouds[3].xv = .3;

  clouds[4].x = 850;
  clouds[4].y = 520;
  clouds[4].xv = .3;
}

Update()
{
  if (water_pos <= -90)
    water_left = false;
  else if (water_pos >= 90)
    water_left = true;

  if (water_left)
    water_pos -= 0.5;
  else
    water_pos += 0.5;
    
  for (i = 0; i < clouds.Size(); i++)
  {
    cloud = clouds[i];
    cloud.x = cloud.x + cloud.xv;
    
    if (cloud.x > 1024 - anims.clouds[i].GetLeft())
      cloud.x = -anims.clouds[i].GetRight();
  }
}

DrawBackground()
{
  sky = anims.sky[0];
  sky.Draw(-sky.GetLeft(),-sky.GetTop());

  anims.mountains[0].Draw(512,730);

  cloud_anims = anims.clouds;
  for (i = 0; i < clouds.Size(); i++)
  {
    cloud = clouds[i];
    cloud_anims[i].Draw(cloud.x,cloud.y);
  }

  anims.water[0].Draw(512+60*sin(-water_pos*3.141592/180.0),745);
  
  land = anims.land[1];
  land.Draw(1024+5-land.GetRight(),665);
}

Draw()
{
}

DrawForeground()
{
  land = anims.land[0];
  land.Draw(1024+5-land.GetRight(),735);

  anims.water[1].Draw(512+90*sin(water_pos*3.141592/180.0),735);
}

IsDead()
{
  return false;
}


IsDestroyable()
{
  return false;
}
