
var x;
var y;

var xv;
var yv;

var fire;

var dead;

var objects;
var particles;
var image;

var parent;

var count;

Init(p_x,p_y,p_xv,p_yv,p_particles,p_objects,p_image,p_parent)
{
  particles = p_particles;
  objects = p_objects;
  image = p_image;
  parent = p_parent;

  x = p_x;
  y = p_y;
  
  xv = p_xv;
  yv = p_yv;

  fire = new ParticleSource(
    -1,			// expire_time
    true,		// active
    0,0,		// x, y
    0,0,		// xv, yv
    0,0,		// xa, ya
    1,			// p_prob
    25,25,		// p_life_min,max
    10,10,		// p_size_min,max
    0,0,		// p_xv_min/max
    0,0,		// p_yv_min/max
    0,0,		// p_xa, p_ya
    new Vector(new Vector(Color(64 ,64 ,64 ,32 ),5),
               new Vector(Color(64 ,64 ,64 ,64 ),10),
               new Vector(Color(64 ,64 ,64 ,64 ),10),
               new Vector(Color(64 ,64 ,64 ,0  ),0))
    );
  particles.AddSource(fire);
}

Update()
{
  fire.SetX(x);
  fire.SetY(y);

  x += xv;
  y += yv;
  
  yv += 0.07;
  
  count++;
  fire.SetActive(count % 5 == 0);

  size = objects.Size();
  for (i = 0; i < size; i++)
  {
    object = objects[i];
    if (object != parent && object != this && object.IsDestroyable())
    {
      if (Intersect(object.GetBounds(),object.GetX(),object.GetY()))
      {
        object.Damage(25);

        splash = new ParticleSource(
          5,		// expire_time
          true,		// active
          x,y,		// x, y
          0,0,		// xv, yv
          0,0,		// xa, ya
          0.25,		// p_prob
          30,30,	// p_life_min,max
          5,13,		// p_size_min,max
          -3,3,		// p_xv_min/max
          -12,-8,	// p_yv_min/max
          0,.45,	// p_xa, p_ya
          new Vector(new Vector(Color(255,255,0  ,128),10),
                     new Vector(Color(255,64 ,0  ,128),5),
                     new Vector(Color(128,0  ,0  ,64 ),5),
                     new Vector(Color(64 ,64 ,64 ,64 ),10),
                     new Vector(Color(64 ,64 ,64 ,0  ),0))
          );
        particles.AddSource(splash);
  
        dead = true;
        fire.Destroy();

        return;
      }
    }
  }

  if (x < 700 && y > 740)
  {
    splash = new ParticleSource(
      5,		// expire_time
      true,		// active
      x,y,		// x, y
      0,0,		// xv, yv
      0,0,		// xa, ya
      0.25,		// p_prob
      30,30,	// p_life_min,max
      5,13,		// p_size_min,max
      -3,3,		// p_xv_min/max
      -12,-8,	// p_yv_min/max
      0,.6,		// p_xa, p_ya
      new Vector(new Vector(Color(128,160,255,160),15),
                 new Vector(Color(255,255,255,160),15),
                 new Vector(Color(255,255,255,0  ),0))
      );
    particles.AddSource(splash);
  
    dead = true;
    fire.Destroy();
    
    return;
  }
  else if (x >= 700 && y > 665)
  {
    splash = new ParticleSource(
      5,		// expire_time
      true,		// active
      x,y,		// x, y
      0,0,		// xv, yv
      0,0,		// xa, ya
      0.25,		// p_prob
      30,30,	// p_life_min,max
      5,13,		// p_size_min,max
      -3,3,		// p_xv_min/max
      -12,-8,	// p_yv_min/max
      0,.45,	// p_xa, p_ya
      new Vector(new Vector(Color(255,255,0  ,128),10),
                 new Vector(Color(255,64 ,0  ,128),5),
                 new Vector(Color(128,0  ,0  ,64 ),5),
                 new Vector(Color(64 ,64 ,64 ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,0  ),0))
      );
    particles.AddSource(splash);
  
    dead = true;
    fire.Destroy();
    
    return;
  }

  if (x < -50 || x > 1024+50 || y > 768+50)
  {
    dead = true;
    fire.Destroy();
    
    return;
  }
}

DrawBackground()
{
}

Draw()
{
  image.Draw(x,y);
}

DrawForeground()
{
}

IsDead()
{
  return dead;
}

IsDestroyable()
{
  return true;
}

Damage(amount)
{
  if (dead)
    return;

  dead = true;

  fire.Destroy();
  splash = new ParticleSource(
    5,		// expire_time
    true,	// active
    x,y,	// x, y
    0,0,	// xv, yv
    0,0,	// xa, ya
    0.25,	// p_prob
    30,30,	// p_life_min,max
    5,13,	// p_size_min,max
    -3,3,	// p_xv_min/max
    -12,-8,	// p_yv_min/max
    0,.45,	// p_xa, p_ya
    new Vector(new Vector(Color(255,255,0  ,128),10),
               new Vector(Color(255,64 ,0  ,128),5),
               new Vector(Color(128,0  ,0  ,64 ),5),
               new Vector(Color(64 ,64 ,64 ,64 ),10),
               new Vector(Color(64 ,64 ,64 ,0  ),0))
    );
    particles.AddSource(splash);
}

GetX()
{
  return x;
}

GetY()
{
  return y;
}

GetBounds()
{
  return image;
}

Intersect(bounds,x_off,y_off)
{
  if (y+image.GetBottom() < y_off+bounds.GetTop())	return false;
  if (y+image.GetTop() > y_off+bounds.GetBottom())	return false;
  if (x+image.GetRight() < x_off+bounds.GetLeft())	return false;
  if (x+image.GetLeft() > x_off+bounds.GetRight())	return false;
  
  return true;
}
