
var anims;
var seq;

var count;
var count2;

var x;
var y;

var xv;
var yv;

var fly;
var move;

var breathe;
var air;
var rotate_angle;

var dir;
var scale_angle;

var fire_left;
var fire_right;
var inhale_left;
var inhale_right;

var shot_debounce;
var breath_meter;

var damage_count;

var objects;
var particles;

Init(p_particles,p_objects)
{
  objects = p_objects;
  particles = p_particles;

  anims = LoadVGZ("art/dragon.vgz");
  breath_meter = LoadVGZ("art/breath_meter.vgz");

  seq = new Vector(0,1,0,2); 
 
  x = 768;
  y = 256;

  fire_left = new ParticleSource(
    -1,			// expire_time
    false,		// active
    0,0,		// x, y
    0,0,		// xv, yv
    0,0,		// xa, ya
    0.5,		// p_prob
    139,140,	// p_life_min,max
    6,12,		// p_size_min,max
    -2,-2.75,	// p_xv_min/max
    3.0,4.0,	// p_yv_min/max
    .02,-.035,	// p_xa, p_ya
    new Vector(new Vector(Color(255,255,0  ,196),20),
               new Vector(Color(255,64 ,0  ,128),20),
               new Vector(Color(128,0  ,0  ,64 ),40),
               new Vector(Color(64 ,64 ,64 ,64 ),60),
               new Vector(Color(64 ,64 ,64 ,0  ),0))
    );
  particles.AddSource(fire_left);

  fire_right = new ParticleSource(
    -1,			// expire_time
    false,		// active
    0,0,		// x, y
    0,0,		// xv, yv
    0,0,		// xa, ya
    0.5,		// p_prob
    139,140,	// p_life_min,max
    8,12,		// p_size_min,max
    2,2.75,		// p_xv_min/max
    3.0,4.0,	// p_yv_min/max
    -.02,-.035,	// p_xa, p_ya
    new Vector(new Vector(Color(255,255,0  ,196),20),
               new Vector(Color(255,64 ,0  ,128),20),
               new Vector(Color(128,0  ,0  ,64 ),40),
               new Vector(Color(64 ,64 ,64 ,64 ),60),
               new Vector(Color(64 ,64 ,64 ,0  ),0))
    );
  particles.AddSource(fire_right);

  inhale_left = new ParticleSource(
    -1,			// expire_time
    false,		// active
    0,0,		// x, y
    0,0,		// xv, yv
    0,0,		// xa, ya
    5,			// p_prob
    5,5,		// p_life_min,max
    6,9,		// p_size_min,max
    8,10,		// p_xv_min/max
    0,0,		// p_yv_min/max
    0,0,		// p_xa, p_ya
    new Vector(new Vector(Color(160,160,160,128),60))
    );
  particles.AddSource(inhale_left);

  inhale_right = new ParticleSource(
    -1,			// expire_time
    false,		// active
    0,0,		// x, y
    0,0,		// xv, yv
    0,0,		// xa, ya
    5,			// p_prob
    5,5,		// p_life_min,max
    6,9,		// p_size_min,max
    -8,-10,		// p_xv_min/max
    0,0,		// p_yv_min/max
    0,0,		// p_xa, p_ya
    new Vector(new Vector(Color(160,160,160,128),60))
    );
  particles.AddSource(inhale_right);
}

Update()
{
  if (damage_count > 0)
    damage_count--;

  x += xv;
  y += yv;
  
  if (x < -anims.normal[0].GetLeft())
  {
    x = -anims.normal[0].GetLeft();
    xv = 0;
  }
  if (x > 1024 - anims.normal[0].GetRight())
  {
    x = 1024 - anims.normal[0].GetRight();
    xv = 0;
  }

  if (y < -anims.normal[0].GetTop())
  {
    y = -anims.normal[0].GetTop();
    yv = 0;
  }
  if (y > 768 - 115 - anims.normal[0].GetBottom())
  {
    y = 768 - 115 - anims.normal[0].GetBottom();
    yv = 0;
  }

  if (fly > 0)
  {
    if (yv > -3)
      yv -= 0.5;
      
    if (yv < -3)
      yv = -3;
  }
  else if (fly < 0)
  {
    if (yv < 4)
      yv += 0.5;
      
    if (yv > 4)
      yv = 4;
  }
  else
  {
    yv += 0.1;
  
    if (yv > 1.5)
      yv = 1.5;
  }

  if (move > 0)
  {
    if (xv > -4)
      xv -= 0.5;
      
    if (xv < -4)
      xv = -4;
  }
  else if (move < 0)
  {
    if (xv < 4)
      xv += 0.5;
      
    if (xv > 4)
      xv = 4;
  }
  else
  {
    if (xv != 0)
      xv *= .8;
  }
  
  if (dir == 0 && scale_angle > 0)
    scale_angle -= 15;
    
  if (dir == 1 && scale_angle < 180)
    scale_angle += 15;

  if (breathe > 0 && rotate_angle > -15)
    rotate_angle -= 1;
  else if (breathe < 0 && rotate_angle < 15)
    rotate_angle += 1;
  else if (breathe == 0)
  {
    if (rotate_angle > 0)
      rotate_angle--;
    else if (rotate_angle < 0)
      rotate_angle++;
  }
  
  scale = (Float(air) + 200.0) / 200.0;
  
  fire_left.SetX(x - scale*115);
  fire_left.SetY(y + scale*5);

  if (breathe > 0 && rotate_angle == -15 && scale_angle < 10 && air == 0 &&
      damage_count == 0)
  {
    fire_left.SetActive(true);

    size = objects.Size();
    for (i = 0; i < size; i++)
    {
      object = objects[i];
      if (object.IsDestroyable())
      {
        if (IntersectLeft(object.GetBounds(),object.GetX(),object.GetY()))
          object.Damage(1);
      }
    }
  }
  else
    fire_left.SetActive(false);

  if (breathe > 0 && rotate_angle == -15 && 
	  scale_angle < 10 && shot_debounce == 0 && air >= 33)
  {
    objects.Add(new Shot(x-scale*115,y+scale*5,-3,5,particles,objects));
    air--;
    shot_debounce = 33;
  }

  fire_right.SetX(x + scale*115);
  fire_right.SetY(y + scale*5);

  if (breathe > 0 && rotate_angle == -15 && scale_angle > 170 && air == 0 && 
      damage_count == 0)
  {
    fire_right.SetActive(true);

    size = objects.Size();
    for (i = 0; i < size; i++)
    {
      object = objects[i];
      if (object.IsDestroyable())
      {
        if (IntersectRight(object.GetBounds(),object.GetX(),object.GetY()))
          object.Damage(1);
      }
    }
  }
  else
    fire_right.SetActive(false);

  if (breathe > 0 && rotate_angle == -15 && 
	  scale_angle > 170 && shot_debounce == 0 && air >= 33 && damage_count == 0)
  {
    objects.Add(new Shot(x+scale*115,y+scale*5,3,5,particles,objects));
    air--;
    shot_debounce = 33;
  }

  inhale_left.SetX(x - scale*85);
  inhale_left.SetY(y - scale*75);

  if (breathe < 0 && rotate_angle == 15 && scale_angle < 10 && damage_count == 0)
    inhale_left.SetActive(true);
  else
    inhale_left.SetActive(false);

  inhale_right.SetX(x + scale*85);
  inhale_right.SetY(y - scale*75);

  if (breathe < 0 && rotate_angle == 15 && scale_angle > 170 && damage_count == 0)
    inhale_right.SetActive(true);
  else
    inhale_right.SetActive(false);

  if (breathe >= 0 && damage_count == 0)
  {
    if (air % 33 != 0)
      air--;
  }

  else if (breathe < 0 && damage_count == 0)
  {
    air++;
    if (air > 100)
      air = 100;
  }
  
  if (shot_debounce > 0)
    shot_debounce--;

  count++;

  factor = 1;
  
  if (fly > 0)
    factor = 1.75;
  else if (fly < 0)
    factor = 1.0/1.75;
    
  if (0 == count%(60.0/anims.normal.GetFrameRate()/factor))
	count2++;
}

DrawBackground()
{
}

Draw()
{
  xscale = yscale = (Float(air) + 200.0) / 200.0;

  rotate = rotate_angle;
  xscale *= 1.0 - sin(scale_angle*3.141592/180.0);

  if (scale_angle >= 90)
  {
    xscale = -xscale;
    rotate = -rotate;

    CullFront();
  }

  if (damage_count > 0)
  {
    scale = 1;
    if (damage_count > 15)
      scale -= (5-(damage_count-15.0))*0.05;
    else if (damage_count > 10)
      scale -= (5-(15.0-damage_count))*0.05;
    else if (damage_count > 5)
      scale += (5-(damage_count-5.0))*0.05;
    else if (damage_count > 0)
      scale += (5-(5.0-damage_count))*0.05;
      
    xscale *= scale;
    yscale /= scale;
  }

  anim = anims.normal;
  if (breathe < 0 || 
	 (breathe > 0 && rotate_angle > -10) ||
	 (breathe > 0 && air > 0 && (air % 33) < 10) ||
	 damage_count > 0)
    anim = anims.inhale;
  else if (breathe > 0 && rotate_angle <= -15)
    anim = anims.exhale;

  anim[seq[count2%seq.Size()]].Draw(x,y,0,rotate,xscale,yscale);

  if (scale_angle >= 90)
    CullBack();
}

DrawForeground()
{
  if (air >= 99)
    breath_meter.fire[2].Draw(58+48+45,54);
  else if (air > 66)
  {
    scale = Float(air-66)/33.0;
    breath_meter.fire[2].Draw(58+48+45,54,0,0,scale);
  }

  if (air >= 66)
    breath_meter.fire[1].Draw(58+48,54);
  else if (air > 33)
  {
    scale = Float(air-33)/33.0;
    breath_meter.fire[1].Draw(58+48,54,0,0,scale);
  }

  if (air >= 33)
    breath_meter.fire[0].Draw(58,52);
  else if (air > 0)
  {
    scale = Float(air)/33.0;
    breath_meter.fire[0].Draw(58,52,0,0,scale);
  }

  if (air > 0)
    head = breath_meter.head[1];
  else
    head = breath_meter.head[0];
   
  head.Draw(0,55);
}

Key(s,m,p)
{
  if (s == "i")
  {
    if (p)
      fly = 1;
    else if (fly == 1)
      fly = 0;
  }
  else if (s == "k")
  {
    if (p)
      fly = -1;
    else if (fly == -1)
      fly = 0;
  }
  else if (s == "j")
  {
    if (p)
    {
      move = 1;
      dir = 0;
    }
    else if (move == 1)
      move = 0;
  }
  else if (s == "l")
  {
    if (p)
    {
      dir = 1;
      move = -1;
    }
    else if (move == -1)
      move = 0;
  }
  else if (s == " ")
  {
    if (p && breathe == 0)
      breathe = 1;
    else if (breathe == 1)
      breathe = 0;
  }
  else if (s == "f")
  {
    if (p && breathe == 0)
      breathe = -1;
    else if (breathe == -1)
      breathe = 0;
  }
}

IsDead()
{
  return false;
}

IsDestroyable()
{
  return true;
}

GetBounds()
{
  return anims.normal[0];
}

GetX()
{
  return x;
}

GetY()
{
  return y;
}

Damage(amount)
{
  if (damage_count == 0)
    damage_count = 20;
}

IntersectLeft(bounds,x_off,y_off)
{
  scale = (Float(air) + 200.0) / 200.0;
  
  right = x-scale*115;
  top = y+scale*5;

  if (top+64 < y_off+bounds.GetTop())		return false;
  if (top > y_off+bounds.GetBottom())		return false;
  if (right < x_off+bounds.GetLeft())		return false;
  if (right-47 > x_off+bounds.GetRight())	return false;
  
  return true;
}

IntersectRight(bounds,x_off,y_off)
{
  scale = (Float(air) + 200.0) / 200.0;
  
  left = x+scale*115;
  top = y+scale*5;

  if (top+64 < y_off+bounds.GetTop())	return false;
  if (top > y_off+bounds.GetBottom())	return false;
  if (left+47 < x_off+bounds.GetLeft())	return false;
  if (left > x_off+bounds.GetRight())	return false;
  
  return true;
}
