
var x;
var y;

var image;
var damage_count;
var hitpoints;
var large;
var smokes;

var dead;

Init(p_x,p_y,p_image,p_hitpoints,particles)
{
  x = p_x;
  y = p_y;
  
  AddHouse(this);

  image = p_image;
  
  hitpoints = p_hitpoints;
  
  if (hitpoints > 150)
    large = true;

  smokes = new Vector();
  if (large)
  {
    fire = new ParticleSource(
      -1,		// expire_time
      false,	// active
      x-2-Rand(image.GetLeft()-2),	// x
      y-2-Rand(image.GetTop()*0.33),	// y
      0,0,		// xv, yv
      0,0,		// xa, ya
      1.0,		// p_prob
      40,40,	// p_life_min,max
      5,11,		// p_size_min,max
      -.2,.2,	// p_xv_min/max
      0,-3,		// p_yv_min/max
      0,-.03,	// p_xa, p_ya
      new Vector(new Vector(Color(255,255,0  ,128),10),
                 new Vector(Color(255,64 ,0  ,128),10),
                 new Vector(Color(128,0  ,0  ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,0  ),0))
      );
    particles.AddSource(fire);
    smokes.Add(fire);

    fire = new ParticleSource(
      -1,		// expire_time
      false,	// active
      x+2+Rand(image.GetRight()-2),	// x
      y-2-Rand(image.GetTop()*0.33),	// y
      0,0,		// xv, yv
      0,0,		// xa, ya
      1.0,		// p_prob
      40,40,	// p_life_min,max
      5,11,		// p_size_min,max
      -.2,.2,	// p_xv_min/max
      0,-3,		// p_yv_min/max
      0,-.03,	// p_xa, p_ya
      new Vector(new Vector(Color(255,255,0  ,128),10),
                 new Vector(Color(255,64 ,0  ,128),10),
                 new Vector(Color(128,0  ,0  ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,0  ),0))
      );
    particles.AddSource(fire);
    smokes.Add(fire);

    fire = new ParticleSource(
      -1,		// expire_time
      false,	// active
      x-2-Rand(image.GetLeft()-2),	// x
      y+image.GetTop()*0.33-Rand(image.GetTop()*0.33),	// y
      0,0,		// xv, yv
      0,0,		// xa, ya
      1.0,		// p_prob
      40,40,	// p_life_min,max
      5,11,		// p_size_min,max
      -.2,.2,	// p_xv_min/max
      0,-3,		// p_yv_min/max
      0,-.03,	// p_xa, p_ya
      new Vector(new Vector(Color(255,255,0  ,128),10),
                 new Vector(Color(255,64 ,0  ,128),10),
                 new Vector(Color(128,0  ,0  ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,0  ),0))
      );
    particles.AddSource(fire);
    smokes.Add(fire);

    fire = new ParticleSource(
      -1,		// expire_time
      false,	// active
      x+2+Rand(image.GetRight()-2),	// x
      y+image.GetTop()*0.33-Rand(image.GetTop()*0.33),	// y
      0,0,		// xv, yv
      0,0,		// xa, ya
      1.0,		// p_prob
      40,40,	// p_life_min,max
      5,11,		// p_size_min,max
      -.2,.2,	// p_xv_min/max
      0,-3,		// p_yv_min/max
      0,-.03,	// p_xa, p_ya
      new Vector(new Vector(Color(255,255,0  ,128),10),
                 new Vector(Color(255,64 ,0  ,128),10),
                 new Vector(Color(128,0  ,0  ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,0  ),0))
      );
    particles.AddSource(fire);
    smokes.Add(fire);
  }
  else
  {
    fire = new ParticleSource(
      -1,		// expire_time
      false,	// active
      x-2-Rand(image.GetLeft()-2),	// x
      y-2-Rand(image.GetTop()/2),	// y
      0,0,		// xv, yv
      0,0,		// xa, ya
      1.0,		// p_prob
      40,40,	// p_life_min,max
      3,9,		// p_size_min,max
      -.2,.2,	// p_xv_min/max
      0,-2,		// p_yv_min/max
      0,-.02,	// p_xa, p_ya
      new Vector(new Vector(Color(255,255,0  ,128),10),
                 new Vector(Color(255,64 ,0  ,128),10),
                 new Vector(Color(128,0  ,0  ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,0  ),0))
      );
    particles.AddSource(fire);
    smokes.Add(fire);

    fire = new ParticleSource(
      -1,		// expire_time
      false,	// active
      x+2+Rand(image.GetRight()-2),	// x
      y-2-Rand(image.GetTop()/2),	// y
      0,0,		// xv, yv
      0,0,		// xa, ya
      1.0,		// p_prob
      40,40,	// p_life_min,max
      3,9,		// p_size_min,max
      -.2,.2,	// p_xv_min/max
      0,-2,		// p_yv_min/max
      0,-.02,	// p_xa, p_ya
      new Vector(new Vector(Color(255,255,0  ,128),10),
                 new Vector(Color(255,64 ,0  ,128),10),
                 new Vector(Color(128,0  ,0  ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,64 ),10),
                 new Vector(Color(64 ,64 ,64 ,0  ),0))
      );
    particles.AddSource(fire);
    smokes.Add(fire);
  }
}

Update()
{
  if (damage_count > 0)
    damage_count--;

  if (large)
  {
    if (hitpoints <= 400)
      smokes[0].SetActive(true);
    if (hitpoints <= 300)
      smokes[1].SetActive(true);
    if (hitpoints <= 200)
      smokes[2].SetActive(true);
    if (hitpoints <= 100)
      smokes[3].SetActive(true);
  }
  else
  {
    if (hitpoints <= 75)
      smokes[0].SetActive(true);
    if (hitpoints <= 25)
      smokes[1].SetActive(true);
  }
  
  if (hitpoints <= 0)
  {
    for (i = 0; i < smokes.Size(); i++)
    {
      smokes[i].SetActive(false);
      smokes[i].Destroy();
    }
  }
}

DrawBackground()
{
}

Draw()
{
  xscale = 1.0;
  yscale = 1.0;
  
  if (hitpoints > 0)
  {
    if (damage_count > 0)
    {
      if (damage_count > 15)
        xscale -= (5-(damage_count-15.0))*0.05;
      else if (damage_count > 10)
        xscale -= (5-(15.0-damage_count))*0.05;
      else if (damage_count > 5)
        xscale += (5-(damage_count-5.0))*0.05;
      else if (damage_count > 0)
        xscale += (5-(5.0-damage_count))*0.05;
      
      yscale = 1.0/xscale;
    }
  }
  else
  {
    yscale = Float(damage_count)/20.0;
  }

  if (xscale != 0 && yscale != 0)
    image.Draw(x,y,0,0,xscale,yscale);
}

DrawForeground()
{
}

IsDead()
{
  if (dead)
    return dead;

  if (hitpoints == 0 && damage_count == 0)
  {
    dead = true;
    RemoveHouse(this);
  }

  return dead;
}

IsDestroyable()
{
  if (hitpoints > 0)
    return true;
  else
    return false;
}

GetBounds()
{
  return image;
}

GetX()
{
  return x;
}

GetY()
{
  return y;
}

Damage(amount)
{
  if (hitpoints <= 0)
    return;

  if (damage_count == 0)
    damage_count = 20;
    
  hitpoints -= amount;

  if (hitpoints <= 0)
  {
    hitpoints = 0;
    damage_count = 20;
  }
}