
var x;
var y;

var xv;
var yv;

var dead;

var objects;
var particles;
var images;

var parent;
var count;
var rotate_angle;

var target;

var damage_count;
var hitpoints;

Init(p_x,p_y,p_particles,p_objects,p_images,p_parent)
{
  particles = p_particles;
  objects = p_objects;
  images = p_images;
  parent = p_parent;
  
  hitpoints = 150;

  x = p_x;
  y = p_y;
}

Update()
{
  if (damage_count > 0)
    damage_count--;

  if (IsNull(target))
    target = FindHouse();
  else if (target.IsDead())
    target = FindHouse();
    
  if (!IsNull(target))
  {
    if (target.GetX() < x)
      x--;
    else if (target.GetX() > x)
      x++;
      
    if (x < 700)
      y_t = 675;
    else if (x > 720)
      y_t = 645;
    else
      y_t = Float(x-700)/20.0*Float(680-650)+650;
      
    if (1 == NumHouses() && x > 860)
      y_t = target.GetY()-20;

    if (y_t > y)
      y++;
    else if (y_t < y)
      y--;
  }

  count++;

  rotate_angle += 0.03;

  size = objects.Size();
  for (i = 0; i < size; i++)
  {
    object = objects[i];
    if (object != parent && object != this && object.IsDestroyable())
    {
      if (Intersect(object.GetBounds(),object.GetX(),object.GetY()))
        object.Damage(1);
    }
  }
}

DrawBackground()
{
}

Draw()
{
  xscale = 1.0;
  yscale = 1.0;
  
  if (hitpoints > 0 && damage_count > 0)
  {
    scale = 1.0;
    if (damage_count > 15)
      scale -= (5-(damage_count-15.0))*0.05;
    else if (damage_count > 10)
      scale -= (5-(15.0-damage_count))*0.05;
    else if (damage_count > 5)
      scale += (5-(damage_count-5.0))*0.05;
    else if (damage_count > 0)
      scale += (5-(5.0-damage_count))*0.05;

    xscale *= scale;
    yscale /= scale;
  }
  else if (hitpoints == 0)
  {
    yscale *= Float(damage_count)/20.0;
  }

  images[(count/7)%3].Draw(x,y,0,7*cos(rotate_angle),xscale,yscale);
}

DrawForeground()
{
}

IsDead()
{
  return dead;
}

IsDestroyable()
{
  return true;
}

Damage(amount)
{
  if (dead)
    return;
    
  hitpoints -= amount;
  if (hitpoints < 0)
    hitpoints = 0;

  if (damage_count == 0)
    damage_count = 20;
    
  if (hitpoints > 0)
    return;

  damage_count = 20;

  dead = true;

  splash = new ParticleSource(
    5,		// expire_time
    true,	// active
    x,y,	// x, y
    0,0,	// xv, yv
    0,0,	// xa, ya
    0.25,	// p_prob
    30,30,	// p_life_min,max
    5,13,	// p_size_min,max
    -3,3,	// p_xv_min/max
    -12,-8,	// p_yv_min/max
    0,.45,	// p_xa, p_ya
    new Vector(new Vector(Color(255,255,0  ,128),10),
               new Vector(Color(255,64 ,0  ,128),5),
               new Vector(Color(128,0  ,0  ,64 ),5),
               new Vector(Color(64 ,64 ,64 ,64 ),10),
               new Vector(Color(64 ,64 ,64 ,0  ),0))
    );
    particles.AddSource(splash);
}

GetX()
{
  return x;
}

GetY()
{
  return y;
}

GetBounds()
{
  return images[0];
}

Intersect(bounds,x_off,y_off)
{
  image = images[0];
  if (y+image.GetBottom() < y_off+bounds.GetTop())	return false;
  if (y+image.GetTop() > y_off+bounds.GetBottom())	return false;
  if (x+image.GetRight() < x_off+bounds.GetLeft())	return false;
  if (x+image.GetLeft() > x_off+bounds.GetRight())	return false;
  
  return true;
}
